### 13.1. Maven

Maven用户可以继承`spring-boot-starter-parent`项目来获取合适的默认设置。该父项目提供以下特性：
- 默认编译级别为Java 1.6
- 源码编码为UTF-8
- 一个依赖管理节点，允许你省略普通依赖的`<version>`标签，继承自`spring-boot-dependencies` POM。
- 合适的[资源过滤](https://maven.apache.org/plugins/maven-resources-plugin/examples/filter.html)
- 合适的插件配置（[exec插件](http://mojo.codehaus.org/exec-maven-plugin/)，[surefire](http://maven.apache.org/surefire/maven-surefire-plugin/)，[Git commit ID](https://github.com/ktoso/maven-git-commit-id-plugin)，[shade](http://maven.apache.org/plugins/maven-shade-plugin/)）
- 针对`application.properties`和`application.yml`的资源过滤

最后一点：由于默认配置文件接收Spring风格的占位符（`${...}`），Maven filtering改用`@..@`占位符（你可以使用Maven属性`resource.delimiter`来覆盖它）。
